$(document).ready(function(){

  $(document).on('submit', 'form[data-xhr]', function(event){
      $('#yukleniyor').show();
      $('#yukleniyorm').show();
      

    event.preventDefault();
    var action    = $(this).attr('action');
    var method    = $(this).attr('method');
    var formData  = new FormData($(this)[0]);

    $.ajax({
      url:  action,
      type: method,
      dataType: 'json',
      data: formData,
      cache: false,
      contentType: false,
      processData: false
    })
    .done(function(result){

      $('#yukleniyor').hide();
      $('#yukleniyorm').hide();


      var options={
        title:  result.t,
        text:   result.m,
        type:   result.s,
        confirmButtonText: 'Tamam'
      };
      if (result.r!=null) {
        options['timer']              = 3000;
        options['showConfirmButton']  = false;
        setTimeout(function(){
          window.location.href  = result.r;
        },3000);
      }
      swal(options);
    })
    .fail(function(){
      $('#yukleniyor').hide();

      
      swal({
        title:  'Hata oluştu!',
        text:   'İstek gerçekleştirilemedi',
        type:   'error',
        confirmButtonText: "Tamam"
      });
    })
  });
});
